% Test the method polysym.double
function test_suite = test_double %#ok<*STOUT>
initTestSuite;

function testEmpty
x = polysym.empty;
y = double(x);
assertTrue(isempty(y))

function testDefault
x = polysym;
y = double(x);
assertTrue(y==0)

function testPi %#ok<*DEFNU>
x = polysym(pi);
y = double(x);
assertElementsAlmostEqual(y,pi,'absolute',eps*100)

function testI
x = polysym(1i);
y = double(x);
assertEqual(y,1i)

function testStringReal
x = polysym('(1+sqrt(5))/2');
y = double(x);
assertElementsAlmostEqual(y,(1+sqrt(5))/2,'absolute',eps*100)

function testStringMixed
x = polysym('(1+sqrt(5))/2');
x = [x x*1i];
y = double(x);
assertElementsAlmostEqual(y,[1 1i]*(1+sqrt(5))/2,'absolute',eps*100)

function testArray
x = repmat(polysym('(1+sqrt(5))/2'),2,4);
y = double(x);
assertElementsAlmostEqual(y,repmat((1+sqrt(5))/2,2,4),'absolute',eps*100)

function testRand
x = exp(1i*randn(3));
y = double(polysym(x));
assertElementsAlmostEqual(y,x,'absolute',eps*100)

function testImpliedConversion
x = ones(2);
x(1) = polysym;
assertEqual(x,[0 1; 1 1])
